# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 2
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR2_strategy.txt
# LLM Suggested Fallback: C

def benevolent_observer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    # Check for simple opponent patterns
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code
    
    if always_c:
        return "D" if total_rounds > 3 else "C"
    if always_d:
        return "D"
    
    # Phased strategy
    if total_rounds <= 3:
        return "C"
    elif total_rounds <= 7:
        if all(move == "C" for move in opp_history):
            return "C" if random.random() < 0.7 else "D"
        else:
            return last_opp_move
    else:
        coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
        if coop_rate >= 0.7:
            return "D" if total_rounds >= 9 else "C"
        else:
            return last_opp_move